/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;

public class PropertiesLoader {
    public static Utf8Properties DEFAULT_PROFILE;
    public static Utf8Properties config;
    public static Utf8Properties mediaProperties;
    private static Utf8Properties profiles;
    private static Hashtable allProps;

    private static Utf8Properties loadProfile(String profile, String profilePath) throws IOException {
        Utf8Properties result = new Utf8Properties();
        InputStream f = null;
        URL url = null;
        if (profilePath != null) {
            url = PropertiesLoader.class.getResource(profilePath);
        }
        f = url.openStream();
        result.load(f);
        allProps.put(new String(profile), result);
        if (Util.onDebug) {
            System.out.println(profile + " profile loaded");
        }
        return result;
    }

    public static Utf8Properties getProfile(String profile) {
        Utf8Properties result = (Utf8Properties)allProps.get(profile);
        if (result == null) {
            result = new Utf8Properties();
            String profilePath = (String)profiles.get(profile);
            if (profilePath != null && !profilePath.equals("")) {
                try {
                    return PropertiesLoader.loadProfile(profile, profilePath);
                }
                catch (IOException e) {
                    if (Util.onDebug) {
                        System.out.println(PropertiesLoader.class + ": Error while loading " + profile + " profile");
                    }
                    e.printStackTrace();
                }
            }
            return DEFAULT_PROFILE;
        }
        return result;
    }

    public static String[] getProfiles() {
        Iterator<Object> it = profiles.keySet().iterator();
        ArrayList<String> res = new ArrayList<String>();
        while (it.hasNext()) {
            String profil = it.next().toString();
            if (!profil.startsWith("css")) continue;
            res.add(profil);
        }
        Collections.sort(res);
        return res.toArray(new String[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        config = new Utf8Properties();
        mediaProperties = new Utf8Properties();
        profiles = new Utf8Properties();
        allProps = new Hashtable();
        InputStream f = null;
        try {
            URL url = PropertiesLoader.class.getResource("Config.properties");
            f = url.openStream();
            config.load(f);
            url = PropertiesLoader.class.getResource(config.getProperty("media"));
            f = url.openStream();
            mediaProperties.load(f);
            url = PropertiesLoader.class.getResource(config.getProperty("profilesProperties"));
            f = url.openStream();
            profiles.load(f);
            String defaultProfile = config.getProperty("defaultProfile");
            String defaultPath = (String)profiles.get(defaultProfile);
            DEFAULT_PROFILE = PropertiesLoader.loadProfile(defaultProfile, defaultPath);
            if (Util.onDebug) {
                System.out.println("Default profile (" + defaultProfile + ") loaded");
            }
        }
        catch (Exception e) {
            System.err.println(PropertiesLoader.class + ": Error while loading default config");
            e.printStackTrace();
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                    f = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

